/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xerrcapi.h
 *       utilities for enhanced error handling
 * -----------------------------------------------------------------*/

#ifndef XERRCAPI_H_INCLUDED
#define XERRCAPI_H_INCLUDED

#ifndef __cplusplus
      
/* This structure is used in error.c and globals initialized in errdata.c */

#ifndef SWIG
typedef struct _XErrorDescription
{
  const char *errname;
  const char *error;
  const bx_errtype errcode;
  const char **lookup1;
  const char **lookup2;
  const char **lookup3;
  const char **lookup4;
  const char **lookup5;
} XErrorDescription;
#endif

#endif


/* --------------------------------------------------------------------------
 * Exported functions
 * -------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 * BestXFuncParamMsg is used by ALL parameter checking routines to record
 * the error if the  check fails.  It is aliased by the macro __FCT_PARAM_MSG
 * which is called by the BX_FCT_PARAM_CHK series of macros.
 * -------------------------------------------------------------------------- */

void EXPORT BestXFuncParamMsg( bx_handletype handle, 
  bx_ccharptrtype pFuncName, 
  bx_ccharptrtype param, 
  bx_ccharptrtype reason
                              );


/* BestXLastErrorParamSet

   set a parameter for the next error message, has to be called before
   BestXLastErrorSet

   arguments:
   index    - which parameter
   errpar    - the parameter
*/

void EXPORT    BestXLastErrorParamSet (bx_handletype handle,
  bx_errparamtype index, 
  bx_int32 errpar
                                       );


/* BestXLastErrorAllParamsSet

   sets all parameters

   arguments:
   errpar1..5    - parameters
*/

void EXPORT    BestXLastErrorAllParamsSet (bx_handletype handle,
  bx_int64 errpar1,
  bx_int64 errpar2,
  bx_int64 errpar3,
  bx_int64 errpar4,
  bx_int64 errpar5
                         );

void EXPORT    BestXLastErrorAllParamsGet (bx_handletype,
  bx_int64ptr errpar1,
  bx_int64ptr errpar2,
  bx_int64ptr errpar3,
  bx_int64ptr errpar4,
  bx_int64ptr errpar5
                         );

void EXPORT    BestXLastErrorParamStringSet (bx_handletype handle,
  bx_ccharptrtype s
                                             );

/* BestXLastErrorSet

   compose the error message

   arguments:
   err        - error code
*/

  bx_errtype EXPORT BestXLastErrorSet (bx_handletype handle, bx_errtype err);


/* BestXLastErrorGet:
   get the error message stored in the handle structure 
*/

bx_errtype EXPORT BestXLastErrorGet (bx_handletype handle);
                                         
bx_ccharptrtype EXPORT BestXLastErrorStringGet (bx_handletype handle);


void        BestXLastErrorStore (bx_handletype handle, bx_errtype err);

bx_ccharptrtype EXPORT BestXErrorStringGet(      
  bx_errtype     error
);

#ifdef __cplusplus
}
#endif

#endif /* _ERROR_H_ */
